require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "FirstAid"

-- Round to 'n' decimal places
local function _round(val, n)
    local p = 10 ^ (n or 0)
    return math.floor(val * p + 0.5) / p
end

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    -- Formulas (per wiki tables):
    --   Fracture heal multiplier: 0.5 + 0.5 * level (L1..L10 = 1.0..5.5)
    --   Bandage/poultice duration: 1.0 + 0.15 * level (shown as +% over base)
    --   Move speed with fracture: 25 + 5 * level (% of normal, L1..L10 = 30..75)
    local healMult     = 0.5 + 0.5 * lvl
    local bandBonusPct = 15 * lvl
    local movePct      = 25 + 5 * lvl

    -- Pretty print heal multiplier without trailing ".0"
    local healMultStr = string.format("%g", healMult)

    -- Header (parity with other skills)
    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    ctx.add(ST.getText("IGUI_DST_FirstAid_val_FractureHealMult", healMultStr))
    ctx.add(ST.getText("IGUI_DST_FirstAid_val_BandageLife", tostring(bandBonusPct)))
    ctx.add(ST.getText("IGUI_DST_FirstAid_val_FractureMoveSpeed", tostring(movePct)))

    -- If later we surface extra hints, add here, e.g.:
    -- ctx.add(ST.getText("IGUI_DST_FirstAid_hint_Removal"))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)